-- This is the schema used to store all relevant information. You can use it to get out your data if the need should ever arise.
-- Also don't forget that Suborbital Reports stores all your reports next to the database. So nothing is ever lost!

PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;

CREATE TABLE metainfo (id integer primary key, version integer, last_update integer NOT NULL);
INSERT INTO "metainfo" VALUES(1, 1, 0);

CREATE TABLE accounts (id integer primary key autoincrement NOT NULL, vendor_id integer NOT NULL UNIQUE, username text NOT NULL, password text NOT NULL, displayName text, active integer NOT NULL);

CREATE TABLE products (id integer primary key NOT NULL, account_id integer references accounts(id) NOT NULL, name text collate nocase NOT NULL, displayName text collate nocase, type text collate nocase NOT NULL, sku text collate nocase NOT NULL);

-- SUMMARY REPORTS TABLES:

CREATE TABLE reports (id integer primary key autoincrement NOT NULL, type text collate nocase NOT NULL, account_id integer references accounts(id) NOT NULL, beginDate text collate nocase NOT NULL, endDate text collate nocase NOT NULL, beginTimestamp integer NOT NULL, endTimestamp integer NOT NULL, fileName text collate nocase unique NOT NULL, checksum text collate nocase NOT NULL);

CREATE TABLE report_lines (id integer primary key autoincrement NOT NULL, report_id integer references reports(id) NOT NULL, report_type text collate nocase NOT NULL, product_id integer references products(id) NOT NULL, productVersion text collate nocase NOT NULL, beginDate text collate nocase NOT NULL, endDate text collate nocase NOT NULL, beginTimestamp integer NOT NULL, endTimestamp integer NOT NULL, reportProvider text collate nocase NOT NULL, reportProviderCountry text collate nocase NOT NULL, saleType text collate nocase NOT NULL, units integer NOT NULL, customerPrice real NOT NULL, customerPriceUSD real NOT NULL, customerCurrency text collate nocase NOT NULL, customerCountry text NOT NULL, developerProceeds real NOT NULL, developerProceedsUSD real NOT NULL, developerProceedsCurrency text collate nocase NOT NULL, revenue real NOT NULL, revenueUSD real NOT NULL, promoCode text, parentIdentifier text, subscription text, period text, category text, exchange_rate real NOT NULL, cmb text NOT NULL, device text NOT NULL, supported_platforms text NOT NULL);

-- FISCAL REPORTS TABLES: (in a future version ...)

-- CREATE TABLE fiscalReports (id integer primary key autoincrement NOT NULL, account_id integer references accounts(id) NOT NULL, region TEXT NOT NULL, month INTEGER NOT NULL, year INTEGER NOT NULL, filename text collate nocase unique NOT NULL, checksum text collate nocase NOT NULL);

-- CREATE TABLE fiscal_report_lines ...

-- SALES DATA TABLES:

CREATE TABLE dailyDataByProduct(id integer primary key autoincrement NOT NULL, day integer NOT NULL, month integer NOT NULL, year integer NOT NULL, timestamp integer NOT NULL, product_id integer references products(id) NOT NULL, sale_type text collate nocase NOT NULL, revenue real NOT NULL, units integer not NULL, report_id integer references reports(id) NOT NULL, geoUnits text collate nocase NOT NULL, geoRevenue text collate nocase NOT NULL);

CREATE TABLE weeklyDataByProduct(id integer primary key autoincrement NOT NULL, begin_timestamp integer NOT NULL, end_timestamp integer NOT NULL, week integer NOT NULL, year integer NOT NULL, product_id integer references products(id) NOT NULL, sale_type text collate nocase NOT NULL, revenue real NOT NULL, units integer NOT NULL, report_id integer references reports(id) NOT NULL, geoUnits text collate nocase NOT NULL, geoRevenue text collate nocase NOT NULL);

CREATE TABLE monthlyDataByProduct(id integer primary key autoincrement NOT NULL, begin_timestamp integer NOT NULL, end_timestamp integer NOT NULL, month integer NOT NULL, year integer NOT NULL, product_id integer references products(id) NOT NULL, sale_type text collate nocase NOT NULL, revenue real NOT NULL, units integer NOT NULL, report_id integer references reports(id) NOT NULL, geoUnits text collate nocase NOT NULL, geoRevenue text collate nocase NOT NULL);

CREATE TABLE yearlyDataByProduct(id integer primary key autoincrement NOT NULL, begin_timestamp integer NOT NULL, end_timestamp integer NOT NULL, year integer NOT NULL, product_id integer references products(id) NOT NULL, sale_type text collate nocase NOT NULL, revenue real NOT NULL, units integer NOT NULL, report_id integer references reports(id) NOT NULL, geoUnits text collate nocase NOT NULL, geoRevenue text collate nocase NOT NULL);


-- EXCHANGE RATE STUFF:

CREATE TABLE exchange_rates (id integer primary key autoincrement, currencyCode text unique NOT NULL, rateToUSD real NOT NULL);
INSERT INTO "exchange_rates" VALUES(1,'OMR',2.5977);
INSERT INTO "exchange_rates" VALUES(2,'BHD',2.6521);
INSERT INTO "exchange_rates" VALUES(3,'MXN',0.0756);
INSERT INTO "exchange_rates" VALUES(4,'TWD',0.0331);
INSERT INTO "exchange_rates" VALUES(5,'ILS',0.2744);
INSERT INTO "exchange_rates" VALUES(6,'MYR',0.3092);
INSERT INTO "exchange_rates" VALUES(7,'AUD',0.8959);
INSERT INTO "exchange_rates" VALUES(8,'GBP',1.6337);
INSERT INTO "exchange_rates" VALUES(9,'ISK',0.0084);
INSERT INTO "exchange_rates" VALUES(10,'KZT',0.0055);
INSERT INTO "exchange_rates" VALUES(11,'INR',0.0164);
INSERT INTO "exchange_rates" VALUES(12,'SEK',0.1399);
INSERT INTO "exchange_rates" VALUES(13,'HKD',0.129);
INSERT INTO "exchange_rates" VALUES(14,'THB',0.031);
INSERT INTO "exchange_rates" VALUES(15,'HUF',0.0041);
INSERT INTO "exchange_rates" VALUES(16,'PKR',0.0097);
INSERT INTO "exchange_rates" VALUES(17,'CLP',0.0017);
INSERT INTO "exchange_rates" VALUES(18,'USD',1.0);
INSERT INTO "exchange_rates" VALUES(19,'NPR',0.0102);
INSERT INTO "exchange_rates" VALUES(20,'NZD',0.8136);
INSERT INTO "exchange_rates" VALUES(21,'IDR',0.0001);
INSERT INTO "exchange_rates" VALUES(22,'KWD',3.4829);
INSERT INTO "exchange_rates" VALUES(23,'CAD',0.9144);
INSERT INTO "exchange_rates" VALUES(24,'SGD',0.7898);
INSERT INTO "exchange_rates" VALUES(25,'DKK',0.1725);
INSERT INTO "exchange_rates" VALUES(26,'MTL',3.40720009803772);
INSERT INTO "exchange_rates" VALUES(27,'BND',0.7898);
INSERT INTO "exchange_rates" VALUES(28,'EUR',1.2845);
INSERT INTO "exchange_rates" VALUES(29,'CNY',0.1628);
INSERT INTO "exchange_rates" VALUES(30,'JPY',0.0092);
INSERT INTO "exchange_rates" VALUES(31,'SKK',4.63999994099140167236e-02);
INSERT INTO "exchange_rates" VALUES(32,'ZAR',0.0905);
INSERT INTO "exchange_rates" VALUES(33,'LKR',0.0077);
INSERT INTO "exchange_rates" VALUES(34,'CHF',1.0641);
INSERT INTO "exchange_rates" VALUES(35,'SAR',0.2666);
INSERT INTO "exchange_rates" VALUES(36,'CZK',0.0466);
INSERT INTO "exchange_rates" VALUES(37,'CYP',2.51320004463195800781e+00);
INSERT INTO "exchange_rates" VALUES(38,'MUR',0.0322);
INSERT INTO "exchange_rates" VALUES(39,'BRL',0.4231);
INSERT INTO "exchange_rates" VALUES(40,'RUB',0.026);
INSERT INTO "exchange_rates" VALUES(41,'TRY',0.4485);
INSERT INTO "exchange_rates" VALUES(42,'NOK',0.1576);
INSERT INTO "exchange_rates" VALUES(43,'AED',0.2723);
INSERT INTO "exchange_rates" VALUES(44,'KRW',0.001);
INSERT INTO "exchange_rates" VALUES(45,'QAR',0.2746);
INSERT INTO "exchange_rates" VALUES(46,'PLN',0.3068);
INSERT INTO "exchange_rates" VALUES(47,'EGP',0.057);

COMMIT;
